#include <windows.h>
#include <shlobj.h>
#include <wininet.h>
#include <string>
#include <list>
#include <iostream>
#include <fstream>
using namespace std;

wstring mplayerfn, lamefn, day; // set by WinMain
wstring url,after,before,title,dir; // set by the dialog or command-line arguments
wstring rahref,rmhref; // set by the "GetLink" function
wstring fnrm,fnwav,fnwav0,fnmp3,fnpod; // set by the "Download" function
HWND hstatus=0,hed=0;
bool processing; HANDLE habort;
HANDLE hpiper=0,hpipew=0;
HINSTANCE hInstance;
HINTERNET hi;
CRITICAL_SECTION critsec; wstring toshow;



const DWORD crc_table[256] = {
  0x00000000L, 0x77073096L, 0xee0e612cL, 0x990951baL, 0x076dc419L,
  0x706af48fL, 0xe963a535L, 0x9e6495a3L, 0x0edb8832L, 0x79dcb8a4L,
  0xe0d5e91eL, 0x97d2d988L, 0x09b64c2bL, 0x7eb17cbdL, 0xe7b82d07L,
  0x90bf1d91L, 0x1db71064L, 0x6ab020f2L, 0xf3b97148L, 0x84be41deL,
  0x1adad47dL, 0x6ddde4ebL, 0xf4d4b551L, 0x83d385c7L, 0x136c9856L,
  0x646ba8c0L, 0xfd62f97aL, 0x8a65c9ecL, 0x14015c4fL, 0x63066cd9L,
  0xfa0f3d63L, 0x8d080df5L, 0x3b6e20c8L, 0x4c69105eL, 0xd56041e4L,
  0xa2677172L, 0x3c03e4d1L, 0x4b04d447L, 0xd20d85fdL, 0xa50ab56bL,
  0x35b5a8faL, 0x42b2986cL, 0xdbbbc9d6L, 0xacbcf940L, 0x32d86ce3L,
  0x45df5c75L, 0xdcd60dcfL, 0xabd13d59L, 0x26d930acL, 0x51de003aL,
  0xc8d75180L, 0xbfd06116L, 0x21b4f4b5L, 0x56b3c423L, 0xcfba9599L,
  0xb8bda50fL, 0x2802b89eL, 0x5f058808L, 0xc60cd9b2L, 0xb10be924L,
  0x2f6f7c87L, 0x58684c11L, 0xc1611dabL, 0xb6662d3dL, 0x76dc4190L,
  0x01db7106L, 0x98d220bcL, 0xefd5102aL, 0x71b18589L, 0x06b6b51fL,
  0x9fbfe4a5L, 0xe8b8d433L, 0x7807c9a2L, 0x0f00f934L, 0x9609a88eL,
  0xe10e9818L, 0x7f6a0dbbL, 0x086d3d2dL, 0x91646c97L, 0xe6635c01L,
  0x6b6b51f4L, 0x1c6c6162L, 0x856530d8L, 0xf262004eL, 0x6c0695edL,
  0x1b01a57bL, 0x8208f4c1L, 0xf50fc457L, 0x65b0d9c6L, 0x12b7e950L,
  0x8bbeb8eaL, 0xfcb9887cL, 0x62dd1ddfL, 0x15da2d49L, 0x8cd37cf3L,
  0xfbd44c65L, 0x4db26158L, 0x3ab551ceL, 0xa3bc0074L, 0xd4bb30e2L,
  0x4adfa541L, 0x3dd895d7L, 0xa4d1c46dL, 0xd3d6f4fbL, 0x4369e96aL,
  0x346ed9fcL, 0xad678846L, 0xda60b8d0L, 0x44042d73L, 0x33031de5L,
  0xaa0a4c5fL, 0xdd0d7cc9L, 0x5005713cL, 0x270241aaL, 0xbe0b1010L,
  0xc90c2086L, 0x5768b525L, 0x206f85b3L, 0xb966d409L, 0xce61e49fL,
  0x5edef90eL, 0x29d9c998L, 0xb0d09822L, 0xc7d7a8b4L, 0x59b33d17L,
  0x2eb40d81L, 0xb7bd5c3bL, 0xc0ba6cadL, 0xedb88320L, 0x9abfb3b6L,
  0x03b6e20cL, 0x74b1d29aL, 0xead54739L, 0x9dd277afL, 0x04db2615L,
  0x73dc1683L, 0xe3630b12L, 0x94643b84L, 0x0d6d6a3eL, 0x7a6a5aa8L,
  0xe40ecf0bL, 0x9309ff9dL, 0x0a00ae27L, 0x7d079eb1L, 0xf00f9344L,
  0x8708a3d2L, 0x1e01f268L, 0x6906c2feL, 0xf762575dL, 0x806567cbL,
  0x196c3671L, 0x6e6b06e7L, 0xfed41b76L, 0x89d32be0L, 0x10da7a5aL,
  0x67dd4accL, 0xf9b9df6fL, 0x8ebeeff9L, 0x17b7be43L, 0x60b08ed5L,
  0xd6d6a3e8L, 0xa1d1937eL, 0x38d8c2c4L, 0x4fdff252L, 0xd1bb67f1L,
  0xa6bc5767L, 0x3fb506ddL, 0x48b2364bL, 0xd80d2bdaL, 0xaf0a1b4cL,
  0x36034af6L, 0x41047a60L, 0xdf60efc3L, 0xa867df55L, 0x316e8eefL,
  0x4669be79L, 0xcb61b38cL, 0xbc66831aL, 0x256fd2a0L, 0x5268e236L,
  0xcc0c7795L, 0xbb0b4703L, 0x220216b9L, 0x5505262fL, 0xc5ba3bbeL,
  0xb2bd0b28L, 0x2bb45a92L, 0x5cb36a04L, 0xc2d7ffa7L, 0xb5d0cf31L,
  0x2cd99e8bL, 0x5bdeae1dL, 0x9b64c2b0L, 0xec63f226L, 0x756aa39cL,
  0x026d930aL, 0x9c0906a9L, 0xeb0e363fL, 0x72076785L, 0x05005713L,
  0x95bf4a82L, 0xe2b87a14L, 0x7bb12baeL, 0x0cb61b38L, 0x92d28e9bL,
  0xe5d5be0dL, 0x7cdcefb7L, 0x0bdbdf21L, 0x86d3d2d4L, 0xf1d4e242L,
  0x68ddb3f8L, 0x1fda836eL, 0x81be16cdL, 0xf6b9265bL, 0x6fb077e1L,
  0x18b74777L, 0x88085ae6L, 0xff0f6a70L, 0x66063bcaL, 0x11010b5cL,
  0x8f659effL, 0xf862ae69L, 0x616bffd3L, 0x166ccf45L, 0xa00ae278L,
  0xd70dd2eeL, 0x4e048354L, 0x3903b3c2L, 0xa7672661L, 0xd06016f7L,
  0x4969474dL, 0x3e6e77dbL, 0xaed16a4aL, 0xd9d65adcL, 0x40df0b66L,
  0x37d83bf0L, 0xa9bcae53L, 0xdebb9ec5L, 0x47b2cf7fL, 0x30b5ffe9L,
  0xbdbdf21cL, 0xcabac28aL, 0x53b39330L, 0x24b4a3a6L, 0xbad03605L,
  0xcdd70693L, 0x54de5729L, 0x23d967bfL, 0xb3667a2eL, 0xc4614ab8L,
  0x5d681b02L, 0x2a6f2b94L, 0xb40bbe37L, 0xc30c8ea1L, 0x5a05df1bL,
  0x2d02ef8dL
};

#define CRC32(c, b) (crc_table[((int)(c) ^ (b)) & 0xff] ^ ((c) >> 8))
#define DO1(buf)  crc = CRC32(crc, *buf++)
#define DO2(buf)  DO1(buf); DO1(buf)
#define DO4(buf)  DO2(buf); DO2(buf)
#define DO8(buf)  DO4(buf); DO4(buf)

DWORD crc32(DWORD crc, const unsigned char *buf, DWORD len)
{ if (buf==NULL) return 0L;
  crc = crc ^ 0xffffffffL;
  while (len >= 8) {DO8(buf); len -= 8;}
  if (len) do {DO1(buf);} while (--len);
  return crc ^ 0xffffffffL;
}

DWORD GetFileCrc(wstring fn)
{ HANDLE hf = CreateFile(fn.c_str(),GENERIC_READ,0,NULL,OPEN_EXISTING,0,NULL);
  if (hf==INVALID_HANDLE_VALUE) return 0;
  DWORD hisize=0; DWORD size = GetFileSize(hf,&hisize);
  HANDLE hmap = CreateFileMapping(hf,NULL,PAGE_READONLY,0,0,NULL);
  if (hmap==NULL) {CloseHandle(hf); return 0;}
  unsigned char *buf = (unsigned char*)MapViewOfFile(hmap,FILE_MAP_READ,0,0,0);
  if (buf==NULL) {CloseHandle(hmap); CloseHandle(hf); return 0;}
  DWORD crc = crc32(0,buf,size);
  UnmapViewOfFile(buf);
  CloseHandle(hmap);
  CloseHandle(hf);
  return crc;
}

wstring enc(const wstring s)
{ wchar_t *buf = new wchar_t[s.length()*3+3]; wchar_t *d=buf;
  for (const wchar_t *c=s.c_str(); *c!=0; c++)
  { if (*c==' ' || *c=='_' || *c=='-' || *c=='/' || *c=='\\' || *c==':' || *c=='.') {*d=*c; d++; continue;}
    if (*c>='a' && *c<='z') {*d=*c; d++; continue;}
    if (*c>='A' && *c<='z') {*d=*c; d++; continue;}
    if (*c>='0' && *c<='9') {*d=*c; d++; continue;}
    *d='%'; d++;
    unsigned char u = (unsigned char)*c;
    wsprintf(d,L"%02x",(int)u);
    d+=2;
  }
  *d=0;
  wstring ws(buf);
  delete[] buf;
  return ws;
}

wstring dec(const wstring s)
{ wchar_t *buf = new wchar_t[s.length()+1]; wchar_t *d=buf;
  for (const wchar_t *c=s.c_str(); *c!=0; c++)
  { if (*c!='%') {*d=*c; d++; continue;}
    int hi=c[1], lo=c[2];
    if (hi>='0' && hi<='9') hi-='0'; else if (hi>='a' && hi<='z') hi-='a'; else if (hi>='A' && hi<='Z') hi-='A';
    if (lo>='0' && lo<='9') lo-='0'; else if (lo>='a' && lo<='z') lo-='a'; else if (lo>='A' && lo<='Z') lo-='A';
    *d = (unsigned char)((hi<<4) + lo);
    d++; c+=2;
  }
  *d=0;
  wstring ws(buf);
  delete[] buf;
  return ws;
}    


wstring ToWchar(const string s)
{ int len = (int)(s.length()*2+2);
  wchar_t *buf = new wchar_t[len];
  MultiByteToWideChar(CP_ACP,0,s.c_str(),-1,buf,len);
  wstring ws(buf);
  delete[] buf;
  return ws;
}

string ToChar(const wstring ws)
{ int len = (int)(ws.length()*4+4);
  char *buf = new char[len];
  WideCharToMultiByte(CP_ACP,0,ws.c_str(),-1,buf,len,NULL,NULL);
  string s(buf);
  delete[] buf;
  return s;
}

int MyGetFileSize(const wstring fn)
{ HANDLE hf = CreateFile(fn.c_str(),GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,0,OPEN_EXISTING,0,0);
  if (hf==INVALID_HANDLE_VALUE) return 0;
  DWORD hisize, size=GetFileSize(hf,&hisize);
  CloseHandle(hf);
  return (int)size;
}

bool FileExists(const wstring fn)
{ DWORD attr = GetFileAttributes(fn.c_str());
  return (attr!=0xFFFFFFFF);
}

bool TouchFile(const wstring fn, const wstring text)
{ HANDLE hf = CreateFile(fn.c_str(),GENERIC_WRITE,FILE_SHARE_READ,0,CREATE_ALWAYS,0,0);
  if (hf==INVALID_HANDLE_VALUE) return false;
  string s = ToChar(text);
  DWORD writ; WriteFile(hf,s.c_str(),(DWORD)s.length(),&writ,0);
  CloseHandle(hf);
  return (writ==s.length());
}

LRESULT CALLBACK PlainWndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{ switch (msg)
  { case WM_CREATE:
    { hed = CreateWindow(L"EDIT",L"",WS_CHILD|WS_VISIBLE|WS_VSCROLL|ES_LEFT|ES_MULTILINE,0,0,100,100,hwnd,NULL,hInstance,0);
    } break;
    case WM_SIZE:
    { RECT rc; GetClientRect(hwnd,&rc);
      MoveWindow(hed,0,0,rc.right,rc.bottom,TRUE);
    } break;
    case WM_PAINT:
    { PAINTSTRUCT ps; BeginPaint(hwnd,&ps);
      EndPaint(hwnd,&ps);
    } break;
    case WM_CLOSE:
    { SetEvent(habort);
      ShowWindow(hwnd,SW_HIDE);
      return 0;
    } break;
  }
  return DefWindowProc(hwnd, msg, wParam, lParam);
}


void ShowStatus(wstring s)
{ SetWindowText(hstatus,title.c_str());
  ShowWindow(hstatus,SW_SHOW);
  s=s+L"\r\n"; unsigned int len=GetWindowTextLength(hed); SendMessage(hed,EM_SETSEL,(WPARAM)len,(LPARAM)len);
  SendMessage(hed,EM_REPLACESEL,FALSE,(LPARAM)s.c_str());
}

void PumpMessages()
{ while (true)
  { MSG msg; for (;;)
    { BOOL res=PeekMessage(&msg,0,0,0,PM_REMOVE); if (!res||msg.message==WM_QUIT) break;
      TranslateMessage(&msg); DispatchMessage(&msg);
    }
    EnterCriticalSection(&critsec); wstring s=toshow; toshow=L""; LeaveCriticalSection(&critsec);
    if (s.length()>0) ShowStatus(s);
    else return;
  }
}


wstring IntToString(int i)
{ wchar_t buf[1024]; wsprintf(buf,L"%i",i); return wstring(buf);
}

wstring LastError()
{ void *buf; DWORD dw=GetLastError(); 
  FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER|FORMAT_MESSAGE_FROM_SYSTEM,0,dw,MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),(LPTSTR)&buf,0,0);
  wstring r((wchar_t*)buf);
  LocalFree(buf);
  return r;
}

wstring LastInternetError()
{ wchar_t buf[16384];
  DWORD err,len=16384; InternetGetLastResponseInfo(&err,buf,&len); buf[16383]=0;
  return wstring(buf);
}

wstring GetLink()
{ ShowStatus(wstring(L"opening ")+url);
  HINTERNET hif = InternetOpenUrl(hi,url.c_str(),NULL,0,INTERNET_FLAG_NO_UI|INTERNET_FLAG_NO_CACHE_WRITE|INTERNET_FLAG_PRAGMA_NOCACHE,0);
  if (hif==0) {wstring err=wstring(L"* Failed to open ")+url+L": "+LastError()+L" - "+LastInternetError(); ShowStatus(err); return err;}
  ShowStatus(wstring(L"downloading ")+url+L".");
  char buf[204800];
  DWORD pos=0; while (true)
  { PumpMessages();
    ShowStatus(L".");
    DWORD red; BOOL res = InternetReadFile(hif,&buf[pos],204800-pos,&red);
    if (!res || red==0) break;
    if (WaitForSingleObject(habort,0)==WAIT_OBJECT_0) break;
    pos+=red; if (pos==204800) {pos=204799;break;}
  }
  buf[pos]=0;
  InternetCloseHandle(hif);
  if (WaitForSingleObject(habort,0)==WAIT_OBJECT_0) return L"* aborted";
  ShowStatus(wstring(L"searching for ")+after+L"/"+before);
  PumpMessages();
  //
  // After: we find "after" in the text and startmarker just after.
  // But if we found it inside an <a.../a>, then startmarker just before that <a.../a>
  // Before: put the endmarker just before the first occurence of "before", or at
  // the end of the text if "before" was empty
  // Now look for the first thing in quotes of the form "...://..\.ra?m..."
  string cbefore = ToChar(before);
  string cafter = ToChar(after);
  //
  char *c=buf, *atag=0, *startmarker=0;
  while (*c!=0 && startmarker==0)
  { if (c[0]=='<' && (c[1]=='a' || c[1]=='A')) atag=c;
    if (c[0]=='/' && (c[1]=='a' || c[1]=='A') && c[2]=='>') atag=0;
    if (strncmp(c,cafter.c_str(),cafter.length())==0) startmarker=c;
    c++;
    if (((c-buf)%1000)==0) PumpMessages();
  }
  if (startmarker==0) {wstring err=wstring(L"* Failed to find ")+after; ShowStatus(err); return err;}
  if (atag!=0) startmarker=atag;
  PumpMessages();
  if (WaitForSingleObject(habort,0)==WAIT_OBJECT_0) return L"* aborted";
  //
  char *endmarker=0;
  if (cbefore.length()==0) endmarker=buf+strlen(buf);
  else while (*c!=0 && endmarker==0)
  { if (strncmp(c,cbefore.c_str(),cbefore.length())==0) endmarker=c;
    c++;
    if (((c-buf)%1000)==0) PumpMessages();
  }
  if (endmarker==0) {wstring err=wstring(L"* Failed to find ")+before; ShowStatus(err); return err;}
  PumpMessages();
  if (WaitForSingleObject(habort,0)==WAIT_OBJECT_0) return L"* aborted";
  //
  *endmarker=0;
  string cspan(startmarker);
  wstring span=ToWchar(cspan);
  ShowStatus(wstring(L"Found text ")+span+L"\r\n\r\n------------\r\n");
  PumpMessages();
  if (WaitForSingleObject(habort,0)==WAIT_OBJECT_0) return L"* aborted";
  //
  c=startmarker; char *qstart=0, *qend=0, *colonslashslash=0, *ram=0; bool inquotes=false;
  while (*c!=0)
  { if (*c=='\"' && qstart==0) {qstart=c; inquotes=true; qend=0; colonslashslash=0; ram=0;}
    else if (*c=='\"' && qstart!=0) {qend=c; inquotes=false; if (colonslashslash && ram) break;}
    else if (c[0]==':' && c[1]=='/' && c[2]=='/' && inquotes) colonslashslash=c;
    else if (c[0]=='.' && (c[1]=='r' || c[1]=='R') && (c[2]=='a' || c[2]=='A') && (c[3]=='m' || c[3]=='M') && inquotes) ram=c;
    c++;
    if (((c-startmarker)%1000)==0) PumpMessages();
  }
  if (qstart==0 || qend==0 || colonslashslash==0 || ram==0) {wstring err=wstring(L"* Failed to find rm"); ShowStatus(err); return err;}
  //
  *qend=0;
  string chref=string(qstart+1);
  rahref=ToWchar(chref);
  ShowStatus(wstring(L"Found ")+rahref+L"\r\n\r\n------------\r\n");
  //
  //
  // Now: download that RAM. 
  ShowStatus(wstring(L"opening ")+rahref);
  hif = InternetOpenUrl(hi,rahref.c_str(),NULL,0,INTERNET_FLAG_NO_UI|INTERNET_FLAG_NO_CACHE_WRITE|INTERNET_FLAG_PRAGMA_NOCACHE,0);
  if (hif==0) {wstring err=wstring(L"* Failed to open ")+rahref+L": "+LastError()+L" - "+LastInternetError(); ShowStatus(err); return err;}
  ShowStatus(wstring(L"downloading ")+rahref+L".");
  pos=0; while (true)
  { ShowStatus(L".");
    PumpMessages();
    DWORD red; BOOL res = InternetReadFile(hif,&buf[pos],204800-pos,&red);
    if (!res || red==0) break;
    if (WaitForSingleObject(habort,0)==WAIT_OBJECT_0) break;
    pos+=red; if (pos==204800) {pos=204799;break;}
  }
  buf[pos]=0;
  string cbuf(buf);
  InternetCloseHandle(hif);
  ShowStatus(wstring(L"Downloaded ram contents: ")+ToWchar(cbuf)+L"\r\n\r\n------------\r\n");
  PumpMessages();
  if (WaitForSingleObject(habort,0)==WAIT_OBJECT_0) return L"* aborted";
  //
  // The RAM will have a list of rtsp:// files (plus maybe some other stuff). We'll pick the last of the rtsps.
  c=buf; char *rtspstart=0, *rtspend=0;  
  while (*c!=0)
  { if (c[0]=='r' && c[1]=='t' && c[2]=='s' && c[3]=='p' && c[4]==':' && c[5]=='/' && c[6]=='/') {rtspstart=c; rtspend=0;}
    if (*c=='\r' && rtspstart!=0 && rtspend==0) rtspend=c;
    if (*c=='\n' && rtspstart!=0 && rtspend==0) rtspend=c;
    c++;
  }
  if (rtspstart!=0 && rtspend==0) rtspend=c;
  if (rtspstart==0) {wstring err=wstring(L"* Failed to find rtsp://"); ShowStatus(err); return err;}
  *rtspend=0; chref=string(rtspstart); rmhref=ToWchar(chref);
  ShowStatus(wstring(L"Found ")+rmhref);
  return L"";
}


wstring Download()
{ wstring err;
  list<wstring> queries;
  const wchar_t *c=rmhref.c_str(), *qstart=0, *firstq=0;
  while (true)
  { if (*c=='?' || *c=='&' || *c==0)
    { if (firstq==0) firstq=c;
      if (qstart!=0) queries.push_back(wstring(qstart,c-qstart));
      qstart=c+1;
      if (*c==0) break;
    }
    c++;
  }
  if (firstq!=0) rmhref=wstring(rmhref.c_str(),firstq-rmhref.c_str());
  wstring start=L"0";
  for (list<wstring>::const_iterator i=queries.begin(); i!=queries.end(); i++)
  { if (wcsncmp(L"start=",i->c_str(),6)==0) start=i->substr(6);
  }
  // Get a clean version
  c=rmhref.c_str(); const wchar_t *lastslash=c; while (*c!=0) {if (*c=='/') lastslash=c+1; c++;}
  wchar_t *buf = new wchar_t[rmhref.length()+1]; c=lastslash; wchar_t *d=buf;
  while (*c!=0)
  { if ((*c>='a' && *c<='z') || (*c>='A' && *c<='Z') || (*c>='0' && *c<='9')) {*d=*c; d++;}
    c++;
  }
  *d=0;
  wstring origfn(buf); delete[] buf;
  //
  SetCurrentDirectory(dir.c_str());
  fnrm = title+L".["+day+L"]."+origfn+L".rm";
  fnwav0 = title+L".["+day+L"]."+origfn+L".0.wav";
  fnwav = title+L".["+day+L"]."+origfn+L".wav";
  fnmp3 = title+L".["+day+L"]."+origfn+L".mp3";
  //
  STARTUPINFO si; ZeroMemory(&si,sizeof(si)); si.cb=sizeof(si);
  si.dwFlags=STARTF_USESTDHANDLES | STARTF_USESHOWWINDOW; 
  si.hStdInput=GetStdHandle(STD_INPUT_HANDLE); si.hStdOutput=hpipew; si.hStdError=GetStdHandle(STD_ERROR_HANDLE);
  si.wShowWindow=SW_HIDE;
  PROCESS_INFORMATION pi; wstring cmd = wstring(L""); DWORD code;
  DWORD size; BOOL res;
  //
  //
  // Download the rm
  if (!FileExists(fnwav0) && !FileExists(fnmp3))
  { ShowStatus(L"\r\n\r\n------------\r\nDownloading rm...");
    DeleteFile(fnrm.c_str());
    ZeroMemory(&pi,sizeof(pi)); cmd = L""; size=0;
    cmd += L"\""+mplayerfn+L"\" -slave -dumpfile \""+fnrm+L"\" -dumpstream \""+rmhref+L"\" -bandwidth 100000";
    ShowStatus(cmd);
    res=CreateProcess(0,(wchar_t*)cmd.c_str(),0,0,TRUE,0,0,0,&si,&pi);
    if (!res) {err=L"* Failed to launch mplayer - "+LastError(); ShowStatus(err); return err;}
    SetPriorityClass(pi.hProcess,BELOW_NORMAL_PRIORITY_CLASS);
    while (WaitForSingleObject(pi.hProcess,10)!=WAIT_OBJECT_0)
    { PumpMessages();
      if (WaitForSingleObject(habort,0)==WAIT_OBJECT_0) TerminateProcess(pi.hProcess,1);
      DWORD newsize=MyGetFileSize(fnrm);
      if (newsize>size+100*1024) {ShowStatus(IntToString(newsize/1024)+L"k"); size=newsize;}
    }
    GetExitCodeProcess(pi.hProcess,&code);
    CloseHandle(pi.hProcess); CloseHandle(pi.hThread);
    if (WaitForSingleObject(habort,0)==WAIT_OBJECT_0) return L"* aborted";
    if (code!=0) {err=L"* mplayer exit code "+IntToString(code); ShowStatus(err); return err;}
    if (!FileExists(fnrm)) {err=L"* failed to create "+fnrm; ShowStatus(err); return err;}
    TouchFile(fnwav0,L"");
  }
  //
  //
  //
  // Convert to wav
  if (!FileExists(fnwav) && !FileExists(fnmp3))
  { ShowStatus(L"\r\n\r\n------------\r\nConverting to wav...");
    DeleteFile(fnwav0.c_str());
    ZeroMemory(&pi,sizeof(pi)); cmd = L""; size=0;
    cmd += L"\""+mplayerfn+L"\" -slave -quiet \""+fnrm+L"\" -ao pcm:fast:file=\""+fnwav0+L"\" -vc null -vo null";
    ShowStatus(cmd);
    res=CreateProcess(0,(wchar_t*)cmd.c_str(),0,0,TRUE,0,0,0,&si,&pi);
    if (!res) {err=L"* Failed to launch mplayer - "+LastError(); ShowStatus(err); return err;}
    SetPriorityClass(pi.hProcess,BELOW_NORMAL_PRIORITY_CLASS);
    while (WaitForSingleObject(pi.hProcess,100)!=WAIT_OBJECT_0)
    { PumpMessages();
      if (WaitForSingleObject(habort,0)==WAIT_OBJECT_0) TerminateProcess(pi.hProcess,1);
      DWORD newsize=MyGetFileSize(fnwav0);
      if (newsize>size+102400*1024) {ShowStatus(IntToString(newsize/1024)+L"k"); size=newsize;}
    }
    GetExitCodeProcess(pi.hProcess,&code);
    CloseHandle(pi.hProcess); CloseHandle(pi.hThread);
    if (WaitForSingleObject(habort,0)==WAIT_OBJECT_0) return L"* aborted";
    if (!FileExists(fnwav0)) {err=L"* failed to create "+fnwav0; ShowStatus(err); TouchFile(fnwav0,L""); return err;}
    if (code!=0) {err=L"* mplayer exit code "+IntToString(code); ShowStatus(err); TouchFile(fnwav0,L""); return err;}
    TouchFile(fnwav,L"");
  }
  //
  //
  // Get the start of the wav
  if (!FileExists(fnmp3))
  { ShowStatus(L"\r\n\r\n------------\r\nFinding start...");
    DeleteFile(fnwav.c_str());
    ZeroMemory(&pi,sizeof(pi)); cmd = L""; size=0;
    cmd += L"\""+mplayerfn+L"\" -slave -quiet \""+fnwav0+L"\" -ss "+start+L" -ao pcm:fast:file=\""+fnwav+L"\" -vc null -vo null";
    ShowStatus(cmd);
    res=CreateProcess(0,(wchar_t*)cmd.c_str(),0,0,TRUE,0,0,0,&si,&pi);
    if (!res) {err=L"* Failed to launch mplayer - "+LastError(); ShowStatus(err); return err;}
    SetPriorityClass(pi.hProcess,BELOW_NORMAL_PRIORITY_CLASS);
    while (WaitForSingleObject(pi.hProcess,100)!=WAIT_OBJECT_0)
    { PumpMessages();
      if (WaitForSingleObject(habort,0)==WAIT_OBJECT_0) TerminateProcess(pi.hProcess,1);
      DWORD newsize=MyGetFileSize(fnwav);
      if (newsize>size+102400*1024) {ShowStatus(IntToString(newsize/1024)+L"k"); size=newsize;}
    }
    GetExitCodeProcess(pi.hProcess,&code);
    CloseHandle(pi.hProcess); CloseHandle(pi.hThread);
    if (WaitForSingleObject(habort,0)==WAIT_OBJECT_0) return L"* aborted";
    if (!FileExists(fnwav)) {err=L"* failed to create "+fnwav; ShowStatus(err); TouchFile(fnwav,L""); return err;}
    if (code!=0) {err=L"* mplayer exit code "+IntToString(code); ShowStatus(err); TouchFile(fnwav,L""); return err;}
    TouchFile(fnmp3,L"");
  }
  //
  // Convert to mp3
  if (!FileExists(fnmp3) || MyGetFileSize(fnmp3)<8)
  { ShowStatus(L"\r\n\r\n------------\r\nConverting to mp3");
    DeleteFile(fnmp3.c_str());
    ZeroMemory(&pi,sizeof(pi)); cmd = L""; size=0;
    cmd += L"\""+lamefn+L"\" -h -V9 -c \""+fnwav+L"\" \""+fnmp3+L"\"";
    ShowStatus(cmd);
    res=CreateProcess(0,(wchar_t*)cmd.c_str(),0,0,TRUE,0,0,0,&si,&pi);
    if (!res) {err=L"* Failed to launch lame - "+LastError(); ShowStatus(err); return err;}
    SetPriorityClass(pi.hProcess,BELOW_NORMAL_PRIORITY_CLASS);
    while (WaitForSingleObject(pi.hProcess,100)!=WAIT_OBJECT_0)
    { PumpMessages();
      if (WaitForSingleObject(habort,0)==WAIT_OBJECT_0) TerminateProcess(pi.hProcess,1);
      DWORD newsize=MyGetFileSize(fnmp3);
      if (newsize>size+100*1024) {ShowStatus(IntToString(newsize/1024)+L"k"); size=newsize;}
    }
    GetExitCodeProcess(pi.hProcess,&code);
    CloseHandle(pi.hProcess); CloseHandle(pi.hThread);
    if (WaitForSingleObject(habort,0)==WAIT_OBJECT_0) return L"* aborted";
    if (code!=0) {err=L"* lame exit code "+IntToString(code); ShowStatus(err); TouchFile(fnmp3,L""); return err;}
    if (!FileExists(fnmp3)) {err=L"* lame to create "+fnmp3; ShowStatus(err); TouchFile(fnmp3,L""); return err;}
    ShowStatus(L"Finished converting to mp3.\r\n\r\n------------\r\n");
    DeleteFile(fnrm.c_str());
    DeleteFile(fnwav0.c_str());
    DeleteFile(fnwav.c_str());
  }
  //
  //
  //
  // Check if this mp3 is the same as any previous downloads which have the same filename (apart from [day])
  wstring match=L"";
  wstring pat = title+L".[????????].*.mp3";
  WIN32_FIND_DATA fdat; HANDLE hfind = FindFirstFile(pat.c_str(),&fdat);
  for (BOOL gotmore=(hfind!=INVALID_HANDLE_VALUE); gotmore; gotmore=FindNextFile(hfind,&fdat))
  { if (fdat.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) continue;
    if (wcscmp(fdat.cFileName,fnmp3.c_str())==0) continue;
    wstring find = fdat.cFileName;
    wstring fday = find.substr(title.length()+2,8);
    wstring forigfn = find.substr(title.length()+12,find.length()-title.length()-16);
    if (wcscmp(forigfn.c_str(),origfn.c_str())==0) match=fdat.cFileName;
  }
  if (hfind!=INVALID_HANDLE_VALUE) FindClose(hfind);
  if (match.length()>0)
  { ShowStatus(wstring(L"Checking if this is the same as the old one ")+match);
    DWORD thissize = MyGetFileSize(fnmp3);
    DWORD oldsize = MyGetFileSize(match);
    if (thissize==oldsize)
    { DWORD thiscrc = GetFileCrc(fnmp3);
      DWORD oldcrc = GetFileCrc(match);
      if (thiscrc==oldcrc)
      { err = L"* This file has already been downloaded.";
        DeleteFile(fnmp3.c_str());
        ShowStatus(err); return err;
      }
    }
  }
  //
  ShowStatus(L"Finished download+conversion.\r\n\r\n------------\r\n");
  //
  return L"";
}


wstring Podcast()
{ ShowStatus(L"Preparing podcast...");
  SetCurrentDirectory(dir.c_str());
  list<pair<string,string> > files;
  wstring pat = title+L".[????????].*.mp3";
  WIN32_FIND_DATA fdat; HANDLE hfind = FindFirstFile(pat.c_str(),&fdat);
  for (BOOL gotmore=(hfind!=INVALID_HANDLE_VALUE); gotmore; gotmore=FindNextFile(hfind,&fdat))
  { if (fdat.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) continue;
    if (wcscmp(fdat.cFileName,fnmp3.c_str())==0) continue;
    wstring find = fdat.cFileName;
    wstring fday = find.substr(title.length()+2,8);
    files.push_back(pair<string,string>(ToChar(fday),ToChar(find)));
    ShowStatus(find);
  }
  if (hfind!=INVALID_HANDLE_VALUE) FindClose(hfind);
  files.sort();
  //
  string podfn = ToChar(title)+".xml";
  ofstream ofs(podfn.c_str());
  SYSTEMTIME systime; GetSystemTime(&systime);
  char buf[1024];
  char* Weekdays[7]={"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};
  char* Months[13]={"","Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
  wsprintfA(buf,"%s, %02i %s %04i %02i:%02i:%02i +0000",Weekdays[systime.wDayOfWeek],(int)systime.wDay,Months[systime.wMonth],(int)systime.wYear,(int)systime.wHour,(int)systime.wMinute,(int)systime.wSecond);
  string date(buf);
  //
  ofs << "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
  ofs << "<rss version=\"2.0\" xmlns:itunes=\"http://www.itunes.com/dtds/podcast-1.0.dtd\">\n";
  ofs << "<channel>\n";
  ofs << "<title>" << ToChar(title) << "</title>\n";
  ofs << "<link>file://" << podfn << "</link>\n";
  ofs << "<description>" << ToChar(title) << ", rebroadcast</description>\n";
  ofs << "<itunes:author>" << ToChar(url) << "</itunes:author>\n";
  ofs << "<language>en-gb</language>\n";
  ofs << "<copyright>(C) " << ToChar(url) << "</copyright>\n";
  ofs << "<ttl>720</ttl>\n";
  ofs << "<pubDate>" << date << "</pubDate>\n";
  ofs << "<lastBuildDate>" << date << "</lastBuildDate>\n";
  ofs << "<itunes:keywords>" << ToChar(title) << "</itunes:keywords>\n";
  for (list<pair<string,string> >::const_iterator i=files.begin(); i!=files.end(); i++)
  { string fday = i->first;
    string fn = i->second;
    int year = atoi(fday.substr(0,4).c_str());
    int month = atoi(fday.substr(4,2).c_str());
    int day = atoi(fday.substr(6,2).c_str());
    SYSTEMTIME systime; systime.wDay=(WORD)day; systime.wDayOfWeek=0; systime.wHour=0; systime.wMilliseconds=0; systime.wMinute=0; systime.wMonth=(int)month; systime.wSecond=0; systime.wYear=(int)year;
    FILETIME ftime; SystemTimeToFileTime(&systime,&ftime); FileTimeToSystemTime(&ftime,&systime);
    wsprintfA(buf,"%s, %02i %s %04i %02i:%02i:%02i +0000",Weekdays[systime.wDayOfWeek],(int)systime.wDay,Months[systime.wMonth],(int)systime.wYear,(int)systime.wHour,(int)systime.wMinute,(int)systime.wSecond);
    string fdate(buf);
    string fnhref = "file://"+ToChar(dir)+"/"+fn;
    int flength = MyGetFileSize(ToWchar(fn));
    ofs << "<item>\n";
    ofs << "  <title>" << fn << "</title>\n";
    ofs << "  <description>" << fn << "</description>\n";
    ofs << "  <pubDate>" << fdate << "</pubDate>\n";
    ofs << "  <guid isPermaLink=\"true\">" << fnhref << "</guid>\n";
    ofs << "  <enclosure url=\"" << fnhref << "\" length=\"" << flength << "\" type=\"audio/mpeg\"/>\n";
    ofs << "</item>\n";
  }
  ofs << "</channel>\n";
  ofs << "</rss>\n";
  ofs.close();
  //
  ShowStatus(wstring(L"\r\n\r\n------------\r\nUpdated podcast ")+ToWchar(podfn));
  //
  return L"";
}


// classID: 0x0080=button, 0x0081=edit, 0x0082=static
typedef struct {DLGITEMTEMPLATE dli; WORD ch; WORD c; WORD t; WORD dummy; WORD cd;} TDlgItem;
typedef struct {DLGTEMPLATE dlt; WORD m; WORD c; WCHAR t[12]; WORD pt; WCHAR f[14];
   TDlgItem i00; TDlgItem i01; TDlgItem i02; TDlgItem i03; TDlgItem i04; TDlgItem i05; TDlgItem i06;
   TDlgItem i07; TDlgItem i08; TDlgItem i09; TDlgItem i10; TDlgItem i11; TDlgItem i12; TDlgItem i13;
   TDlgItem i14;
  } TDlgData;

TDlgData dtp={{DS_MODALFRAME|DS_SETFONT|DS_CENTER|WS_POPUP|WS_CAPTION|WS_SYSMENU|WS_VISIBLE,0,15,0,0,280,188},
      0,0,L"rm2podcast",8,L"MS Sans Serif",
   {{SS_LEFT|WS_CHILD|WS_VISIBLE,0,7,7,265,8,100},0xFFFF,0x0082,0,0,0}, // "On this &webpage:"
   {{ES_AUTOHSCROLL|WS_CHILD|WS_VISIBLE,0,7,17,265,14,101},0xFFFF,0x0081,0,0,0}, 
   {{SS_LEFT|WS_CHILD|WS_VISIBLE,0,7,36,265,8,102},0xFFFF,0x0082,0,0,0}, // "Find the first realaudio link &after (or including) this text:"
   {{ES_AUTOHSCROLL|WS_CHILD|WS_VISIBLE,0,7,46,265,14,103},0xFFFF,0x0081,0,0,0}, 
   {{SS_LEFT|WS_CHILD|WS_VISIBLE,0,7,66,265,8,104},0xFFFF,0x0082,0,0,0}, // "and &before (or including) this text:"
   {{ES_AUTOHSCROLL|WS_CHILD|WS_VISIBLE,0,7,76,265,14,105},0xFFFF,0x0081,0,0,0}, 
   {{SS_LEFT|WS_CHILD|WS_VISIBLE,0,7,98,265,8,106},0xFFFF,0x0082,0,0,0}, // "Save it as a podcast with this &title:"
   {{ES_AUTOHSCROLL|WS_CHILD|WS_VISIBLE,0,7,108,265,14,107},0xFFFF,0x0081,0,0,0}, 
   {{SS_LEFT|WS_CHILD|WS_VISIBLE,0,7,130,265,8,108},0xFFFF,0x0082,0,0,0}, // "In this &directory:"
   {{ES_AUTOHSCROLL|WS_CHILD|WS_VISIBLE,0,7,140,235,14,109},0xFFFF,0x0081,0,0,0}, 
   {{BS_CENTER|BS_TEXT|WS_CHILD|WS_VISIBLE,0,251,140,21,14,110},0xFFFF,0x0080,0,0,0}, // "..."
   {{BS_CENTER|BS_TEXT|WS_CHILD|WS_VISIBLE,0,7,167,50,14,111},0xFFFF,0x0080,0,0,0}, // "&Test..."
   {{BS_CENTER|BS_TEXT|WS_CHILD|WS_VISIBLE,0,63,167,50,14,112},0xFFFF,0x0080,0,0,0}, // "&Help..."
   {{BS_CENTER|BS_TEXT|WS_CHILD|WS_VISIBLE,0,163,167,50,14,IDCANCEL},0xFFFF,0x0080,0,0,0}, // "&Cancel"
   {{BS_DEFPUSHBUTTON|BS_CENTER|BS_TEXT|WS_CHILD|WS_VISIBLE,0,222,167,50,14,IDOK},0xFFFF,0x0080,0,0,0}, // "&OK"
 };


wstring BrowseForFolderInitialDir;
int CALLBACK BrowseForFolderCallback(HWND hwnd,UINT uMsg,LPARAM, LPARAM)
{ if (uMsg==BFFM_INITIALIZED)
  { if (BrowseForFolderInitialDir.length()>0) SendMessage(hwnd,BFFM_SETSELECTION,TRUE,(LPARAM)BrowseForFolderInitialDir.c_str());
  }
  return 0;
}

wstring BrowseForFolder(HWND hwnd,const wstring folder)
{ IMalloc *shmalloc; HRESULT hr;
  hr = SHGetMalloc(&shmalloc);
  if (hr!=S_OK) return false;
  //
  BROWSEINFO bi; ZeroMemory(&bi,sizeof(bi));
  bi.hwndOwner=hwnd; bi.pidlRoot=0;
  wchar_t c[MAX_PATH]; bi.pszDisplayName=c;
  bi.lpszTitle=0; bi.ulFlags=BIF_RETURNONLYFSDIRS;
  bi.lpfn=BrowseForFolderCallback;
  BrowseForFolderInitialDir = folder;
  ITEMIDLIST *pidl = SHBrowseForFolder(&bi);
  if (pidl==0) {shmalloc->Release();return L"";}
  wchar_t buf[MAX_PATH];
  BOOL res = SHGetPathFromIDList(pidl,buf);
  shmalloc->Free(pidl); shmalloc->Release();
  if (!res) return L"";
  return wstring(buf);
}

bool CreateShortcut(const wstring shfn, const wstring cmd, const wstring args)
{ HRESULT hres;
  IShellLink* ilink; hres=CoCreateInstance(CLSID_ShellLink,NULL,CLSCTX_INPROC_SERVER,IID_IShellLink,(LPVOID*)&ilink); if (!SUCCEEDED(hres) || ilink==0) return false;
  IPersistFile* ipf; hres=ilink->QueryInterface(IID_IPersistFile,(void**)&ipf); if (!SUCCEEDED(hres) || ipf==0) {ilink->Release(); return false;}
  ilink->SetPath(cmd.c_str());
  ilink->SetArguments(args.c_str());
  ipf->Save(shfn.c_str(), FALSE);
  ipf->Release();
  ilink->Release();
  return true;
}


INT_PTR CALLBACK DialogProc(HWND hdlg,UINT msg,WPARAM wParam,LPARAM lParam)
{ switch (msg)
  { case WM_INITDIALOG:
    { SetDlgItemText(hdlg,100,L"On this &webpage:");
      SetDlgItemText(hdlg,102,L"Find the first realaudio link &after (or including) this text:");
      SetDlgItemText(hdlg,104,L"and &before (or including) this text:");
      SetDlgItemText(hdlg,106,L"Save it as a podcast with this &title:");
      SetDlgItemText(hdlg,108,L"In this &directory:");
      SetDlgItemText(hdlg,110,L"...");
      SetDlgItemText(hdlg,111,L"&Test...");
      SetDlgItemText(hdlg,112,L"&Help...");
      SetDlgItemText(hdlg,IDCANCEL,L"&Cancel");
      SetDlgItemText(hdlg,IDOK,L"&OK");
      //
      SetDlgItemText(hdlg,101,L"http://www.harryshearer.com/active/leShow.php");
      SetDlgItemText(hdlg,103,L"program)");
      SetDlgItemText(hdlg,107,L"Harry Shearer");
      wchar_t buf[MAX_PATH]; SHGetFolderPath(0,CSIDL_MYMUSIC,0,SHGFP_TYPE_CURRENT,buf);
      SetDlgItemText(hdlg,109,buf);
      return TRUE;
    }
    case WM_COMMAND:
    { wchar_t buf[16384];
      GetDlgItemText(hdlg,101,buf,16383); buf[16383]=0; url=buf;
      GetDlgItemText(hdlg,103,buf,16383); buf[16383]=0; after=buf;
      GetDlgItemText(hdlg,105,buf,16383); buf[16383]=0; before=buf;
      GetDlgItemText(hdlg,107,buf,16383); buf[16383]=0; title=buf;
      GetDlgItemText(hdlg,109,buf,16383); buf[16383]=0; dir=buf;
      if (LOWORD(wParam)==IDCANCEL) {if (processing) SetEvent(habort); else EndDialog(hdlg,IDCANCEL);}
      else if (LOWORD(wParam)==IDOK)
      { wchar_t buf[MAX_PATH]; 
        GetModuleFileName(0,buf,MAX_PATH); wstring cmd=wstring(L"\"")+buf+L"\"";
        wstring args;
        args += L"\""+enc(url)+L"\" \""+enc(after)+L"\" \""+enc(before)+L"\" \""+enc(title)+L"\" \""+enc(dir)+L"\"";
        SHGetSpecialFolderPath(hdlg,buf,CSIDL_DESKTOP,FALSE);
        wstring sfn = wstring(buf)+L"\\"+title+L".lnk";        
        bool res = CreateShortcut(sfn,cmd,args);
        wstring err; 
        if (res) err=wstring(L"Created a shortcut for this podcast on the desktop.\r\nRun that shortcut to download the most recent episodes.\r\nUse ControlPanel>ScheduledTasks to run it automatically.\r\n\r\n")+sfn;
        else err=wstring(L"Error creating the shortcut ")+sfn;
        MessageBox(hdlg,err.c_str(),L"rm2podcast",MB_OK);
        if (processing) SetEvent(habort); else EndDialog(hdlg,IDOK);
      }
      else if (LOWORD(wParam)==111)
      { ResetEvent(habort); rahref=L""; rmhref=L""; wstring msg;
        processing=true; msg=GetLink(); processing=false;
        if (WaitForSingleObject(habort,0)==WAIT_OBJECT_0) {SetWindowText(hed,L""); ShowWindow(hstatus,SW_HIDE); return TRUE;}
        if (msg.length()!=0) {MessageBox(hdlg,msg.c_str(),L"rm2podcast test",MB_OK); return TRUE;}
        processing=true; msg=Download(); processing=false;
        if (WaitForSingleObject(habort,0)==WAIT_OBJECT_0) {SetWindowText(hed,L""); ShowWindow(hstatus,SW_HIDE); return TRUE;}
        if (msg.length()!=0) {MessageBox(hdlg,msg.c_str(),L"rm2podcast test",MB_OK); return TRUE;}
        processing=true; msg=Podcast(); processing=false;
        if (WaitForSingleObject(habort,0)==WAIT_OBJECT_0) {SetWindowText(hed,L""); ShowWindow(hstatus,SW_HIDE); return TRUE;}
        if (msg.length()!=0) {MessageBox(hdlg,msg.c_str(),L"rm2podcast test",MB_OK); return TRUE;}
      }
      else if (LOWORD(wParam)==110)
      { wstring s = BrowseForFolder(hdlg,dir);
        if (s.length()==0) return TRUE;
        SetDlgItemText(hdlg,109,s.c_str());
      }
      else if (LOWORD(wParam)==112) // Help
      { ShellExecute(0,L"open",L"http://www.wischik.com/lu/Programmer/Rm2podcast",0,0,SW_SHOWNORMAL);
      }
      return TRUE;
    }
  }
  return FALSE;
}


DWORD WINAPI PipeThread(void *)
{ char buf[1025];
  while (true)
  { DWORD red; BOOL res=ReadFile(hpiper,buf,1024,&red,0);
    if (red==0 || !res) return 0;
    buf[red]=0;
    EnterCriticalSection(&critsec);
    toshow += ToWchar(string(buf));
    LeaveCriticalSection(&critsec);
  }
}

wstring GetArg(wchar_t const **ptr)
{ const wchar_t *c = *ptr;
  while (*c==' ') c++;
  if (*c=='\"')
  { c++; const wchar_t *start = c;
    while (*c!='\"' && *c!=0) c++;
    wstring s(start,c-start);
    if (*c=='\"') c++;
    *ptr=c; return s;
  }
  const wchar_t *start=c;
  while (*c!=' ' && *c!=0) c++;
  wstring s(start,c-start);
  *ptr=c; return s;
}

int WINAPI WinMain(HINSTANCE h,HINSTANCE,LPSTR,int)
{ wchar_t buf[MAX_PATH]; GetWindowsDirectory(buf,MAX_PATH);
  mplayerfn=wstring(buf); mplayerfn=mplayerfn+L"\\mplayer.exe";
  lamefn=wstring(buf); lamefn=lamefn+L"\\lame.exe";
  wstring err=L""; DWORD attr;
  attr=GetFileAttributes(lamefn.c_str()); if (attr==0xFFFFFFFF) err=lamefn;
  attr=GetFileAttributes(mplayerfn.c_str()); if (attr==0xFFFFFFFF) err=mplayerfn;
  if (err.length()>0)
  { err=wstring(L"We need ")+err+L" to have been installed.\r\nClick OK to go online and read instructions";
    int res=MessageBox(0,err.c_str(),L"rm2podcast",MB_ICONEXCLAMATION|MB_OKCANCEL);
    if (res!=IDOK) return 1;
    ShellExecute(0,L"open",L"http://www.wischik.com/lu/Programmer/Rm2podcast",0,0,SW_SHOWNORMAL);
    return 1;
  }
  SYSTEMTIME systime, lsystime; GetSystemTime(&systime);
  SystemTimeToTzSpecificLocalTime(0,&systime,&lsystime);
  wsprintf(buf,L"%04i%02i%02i",(int)lsystime.wYear,(int)lsystime.wMonth,(int)lsystime.wDay);
  day=wstring(buf);
  //
  CoInitialize(NULL);
  hi = InternetOpen(L"Mozilla/4.0 (compatible; MSIE 6.0; Windows XP;)",INTERNET_OPEN_TYPE_PRECONFIG,NULL,NULL,0);
  habort = CreateEvent(0,TRUE,FALSE,0);
  InitializeCriticalSection(&critsec);
  hInstance=h;
  WNDCLASSEX wcex; ZeroMemory(&wcex,sizeof(wcex)); wcex.cbSize = sizeof(WNDCLASSEX);
  wcex.style = CS_HREDRAW | CS_VREDRAW;
  wcex.lpfnWndProc = (WNDPROC)PlainWndProc;
  wcex.hInstance = hInstance;
  wcex.hCursor = LoadCursor(NULL, IDC_ARROW);
  wcex.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
  wcex.lpszClassName = L"rm2podcastClass";
  RegisterClassEx(&wcex);
  hstatus = CreateWindowEx(0x08000000L|WS_EX_APPWINDOW,L"rm2podcastClass", L"rm2podcast", WS_OVERLAPPEDWINDOW, 0,0,400,400, NULL, NULL, hInstance, NULL);
  SECURITY_ATTRIBUTES sa; ZeroMemory(&sa,sizeof(sa)); sa.nLength=sizeof(sa);
  sa.bInheritHandle=TRUE; sa.lpSecurityDescriptor=0;
  CreatePipe(&hpiper,&hpipew,&sa,0);
  HANDLE hthread = CreateThread(0,0,PipeThread,0,0,0);
  //
  const wchar_t *c=GetCommandLine();
  wstring cmd=GetArg(&c);
  url=dec(GetArg(&c));
  after=dec(GetArg(&c));
  before=dec(GetArg(&c));
  title=dec(GetArg(&c));
  dir=dec(GetArg(&c));
  if (url.length()>0 && (after.length()>0 || before.length()>0) && title.length()>0 && dir.length()>0)
  { wstring msg=L"";
    if (msg.length()==0) msg = GetLink();
    if (msg.length()==0) msg = Download();
    if (msg.length()==0) msg = Podcast();
  }
  else
  { DialogBoxIndirect(hInstance,(DLGTEMPLATE*)&dtp,0,DialogProc); 
  }
  //
  CloseHandle(hpipew);
  WaitForSingleObject(hthread,INFINITE);
  CloseHandle(hpiper);
  CloseHandle(hthread);
  DestroyWindow(hstatus);
  InternetCloseHandle(hi);
  CloseHandle(habort);
  DeleteCriticalSection(&critsec);
  CoUninitialize();
  return 0;
}
